/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

public class VWAdminWorkObjectTableData {
    public static final int LOCKED_UNDETERMINED = -1;
    public static final int LOCKED_BY_SYSTEM = 0;
    public static final int LOCKED_BY_CURRENT_USER = 1;
    public static final int LOCKED_BY_OTHERS = 2;
    public static final int LOCKED_BY_NONE = 3;
    protected VWParticipant m_logonUser;
    protected VWWorkObject m_wob;
    protected boolean m_bDirty = false;
    protected boolean m_bToBeRemoved = false;
    protected int m_displayRowIndex = -1;
    protected int m_rowIndex = -1;
    private boolean m_moreChildren = false;
    protected int m_lockedStatus = -1;
    protected VWParticipant m_lockedUser = null;
    protected Vector m_childrenWobs = new Vector();

    public VWAdminWorkObjectTableData(VWWorkObject wob, VWParticipant logonUser, boolean moreChildren, int displayRowIndex, int rowIndex) {
        try {
            this.m_wob = wob;
            this.m_logonUser = logonUser;
            this.m_bDirty = false;
            this.m_bToBeRemoved = false;
            this.m_displayRowIndex = displayRowIndex;
            this.m_rowIndex = rowIndex;
            this.m_moreChildren = moreChildren;
            this.updateLockedInfo();
            if (this.m_moreChildren) {
                this.buildChildren(wob);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void resetData() {
        try {
            this.m_bDirty = false;
            this.m_bToBeRemoved = false;
            this.updateLockedInfo();
            this.resetChildren();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void updateLockedInfo() {
        this.resetLockedUser();
        this.resetLockedStatus();
    }

    protected void setDirty(boolean flag) {
        this.m_bDirty = flag;
    }

    protected void setToBeRemoved(boolean flag) {
        this.m_bToBeRemoved = flag;
    }

    protected VWWorkObject getWob() {
        return this.m_wob;
    }

    protected boolean isDirty() {
        return this.m_bDirty;
    }

    protected boolean isToBeRemoved() {
        return this.m_bToBeRemoved;
    }

    protected int getRowIndex() {
        return this.m_rowIndex;
    }

    protected void setRowIndex(int index) {
        this.m_rowIndex = index;
    }

    protected int getDisplayRowIndex() {
        return this.m_displayRowIndex;
    }

    protected void setDisplayRowIndex(int index) {
        this.m_displayRowIndex = index;
    }

    protected Vector getChildren() {
        return this.m_childrenWobs;
    }

    protected void resetChildren() {
        if (this.m_moreChildren) {
            this.buildChildren(this.m_wob);
        }
    }

    protected VWParticipant getLockedUser() {
        return this.m_lockedUser;
    }

    protected int getLockedStatus() {
        return this.m_lockedStatus;
    }

    private void resetLockedUser() {
        try {
            this.m_lockedUser = this.m_wob.getLockedUserPx();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void resetLockedStatus() {
        if (this.m_logonUser == null) {
            this.m_lockedStatus = -1;
            return;
        }
        try {
            int lockedStatus = this.m_wob.fetchLockedStatus();
            if (lockedStatus == 2) {
                this.m_lockedStatus = 0;
            } else if (lockedStatus == 0) {
                this.m_lockedStatus = 3;
            } else {
                VWParticipant lockedUser = this.getLockedUser();
                if (lockedUser != null) {
                    this.m_lockedStatus = VWStringUtils.compareUsers(lockedUser.getParticipantName(), this.m_logonUser.getParticipantName()) ? 1 : 2;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            this.m_lockedStatus = -1;
        }
    }

    private void buildChildren(VWWorkObject parentWob) {
        VWWorkObject wob = null;
        try {
            if (this.m_childrenWobs != null) {
                this.m_childrenWobs.removeAllElements();
            }
            VWProcess proc = parentWob.fetchProcess();
            while (proc.hasNext()) {
                wob = proc.next();
                if (wob == null || wob.getWorkObjectNumber().equals(parentWob.getWorkObjectNumber())) continue;
                VWAdminWorkObjectTableData dataField = new VWAdminWorkObjectTableData(wob, this.m_logonUser, false, -1, -1);
                this.m_childrenWobs.addElement(dataField);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

